/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.query.VWIndexTableModel;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWIndexPanel
extends JPanel {
    private JLabel m_indexLabel = new JLabel();
    private VWIndexTableModel m_indexTableModel = null;
    private JScrollPane m_scrollPane = null;
    private VWTable m_indexTable = null;
    private String m_indexName = null;

    public VWIndexPanel() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.createTopPanel(), "First");
            this.add((Component)this.createTablePanel(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getIndexName() {
        return this.m_indexName;
    }

    protected int getQueryFlags() {
        if (this.m_indexTableModel == null) {
            return 0;
        }
        return this.m_indexTableModel.getQueryFlags();
    }

    protected void setQueryFlags(int nFlags) {
        if (this.m_indexTableModel != null) {
            this.m_indexTableModel.setQueryFlags(nFlags);
            this.m_indexTable.setModel(this.m_indexTableModel);
        }
    }

    protected Object[] getMaxValues() {
        if (this.m_indexTableModel == null) {
            return null;
        }
        return this.m_indexTableModel.getRowValues(1);
    }

    protected void setMaxValues(Object[] items) {
        if (this.m_indexTableModel != null) {
            this.m_indexTableModel.setRowValues(items, 1);
            this.m_indexTable.setModel(this.m_indexTableModel);
        }
    }

    protected Object[] getMinValues() {
        if (this.m_indexTableModel == null) {
            return null;
        }
        return this.m_indexTableModel.getRowValues(0);
    }

    protected void setMinValues(Object[] items) {
        if (this.m_indexTableModel != null) {
            this.m_indexTableModel.setRowValues(items, 0);
            this.m_indexTable.setModel(this.m_indexTableModel);
        }
    }

    protected void resetTable(VWIndexDefinition indexDef, VWExposedFieldDefinition[] exposedFields) {
        try {
            if (indexDef == null || exposedFields == null) {
                this.m_indexTableModel = null;
                this.m_indexTable.setModel(new DefaultTableModel());
                this.m_indexName = "";
                this.resetIndexLabel(VWResource.s_default);
                return;
            }
            this.m_indexName = indexDef.getName();
            this.resetIndexLabel(this.m_indexName);
            String[] fieldNames = null;
            fieldNames = indexDef.getFieldNames();
            if (fieldNames == null || fieldNames.length == 0) {
                this.m_indexTableModel = null;
                this.m_indexTable.setModel(new DefaultTableModel());
                return;
            }
            this.m_indexTableModel = new VWIndexTableModel();
            this.m_indexTableModel.initialize(indexDef, exposedFields);
            this.m_indexTable.setModel(this.m_indexTableModel);
            this.m_indexTable.setRowSelectionAllowed(false);
            this.m_indexTable.setCellSelectionEnabled(true);
            if (this.m_indexTable.getColumnCount() > 0) {
                TableColumnModel columnModel = this.m_indexTable.getColumnModel();
                TableColumn columnRowNum = columnModel.getColumn(0);
                columnRowNum.setMinWidth(80);
                columnRowNum.setMaxWidth(80);
                columnRowNum = columnModel.getColumn(1);
                columnRowNum.setMinWidth(80);
                columnRowNum.setMaxWidth(80);
                for (int i = 2; i < this.m_indexTable.getColumnCount(); ++i) {
                    columnRowNum = columnModel.getColumn(i);
                    columnRowNum.setCellRenderer(new VWFieldsCellRenderer());
                    columnRowNum.setCellEditor(new IndexCellEditor(new JTextField()));
                }
            }
            this.m_indexTable.setSize(this.m_scrollPane.getSize());
            this.m_indexTable.sizeColumnsToFit(-1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void stopEditing() {
        this.m_indexTable.stopEditing();
    }

    protected boolean getErrorValidatingFlag() {
        return this.m_indexTableModel.getErrorValidatingFlag();
    }

    protected void setErrorValidatingFlag(boolean flag) {
        this.m_indexTableModel.setErrorValidatingFlag(flag);
    }

    private JPanel createTopPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)this.createIndexPanel(), "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createIndexPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new FlowLayout(3));
            this.resetIndexLabel(VWResource.s_default);
            mainPanel.add(this.m_indexLabel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createTablePanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            this.m_indexTableModel = new VWIndexTableModel();
            this.m_indexTable = new VWTable(this.m_indexTableModel);
            this.m_scrollPane = new JScrollPane(this.m_indexTable);
            mainPanel.add((Component)this.m_scrollPane, "Center");
            VWAccessibilityHelper.setAccessibility(this.m_indexTable, this, VWResource.s_indexTable, VWResource.s_indexTable);
            this.m_indexTable.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWIndexPanel.this.m_indexTable == null || VWIndexPanel.this.m_indexTable.getModel() == null || VWIndexPanel.this.m_indexTable.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private void resetIndexLabel(String indexName) {
        String label = VWResource.s_index + indexName;
        this.m_indexLabel.setText(label);
        VWAccessibilityHelper.setAccessibility(this.m_indexLabel, this, label, label);
    }

    class IndexCellEditor
    extends DefaultCellEditor {
        JTextField m_textField;

        public IndexCellEditor(JTextField textField) {
            super(textField);
            this.m_textField = textField;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_textField.setText("");
            } else {
                String string = VWFieldsCellRenderer.toString(value);
                this.m_textField.setText(string);
            }
            return this.m_textField;
        }
    }
}

